//---------------------------------------------------------------------------
#ifndef Unit2H
#define Unit2H
//---------------------------------------------------------------------------
#include <vcl\Classes.hpp>
#include <vcl\Controls.hpp>
#include <vcl\StdCtrls.hpp>
#include <vcl\Forms.hpp>
#include <vcl\ComCtrls.hpp>
#include <vcl\ExtCtrls.hpp>
#include <vcl\Dialogs.hpp>
#include <vcl\Menus.hpp>
#include <vcl\FileCtrl.hpp>
#include <vcl\clipbrd.hpp>
//---------------------------------------------------------------------------
class TForm2 : public TForm
{
__published:	// IDE-managed Components
	TFindDialog *FindDlg;
	TReplaceDialog *ReplaceDlg;
	TRichEdit *MessageEdit;
	TStatusBar *StatusBar;
	TPanel *SplitPanel;
	TPopupMenu *PopupMenu;
	TMenuItem *PopupMenu_ClosePage;
	TMenuItem *PopupMenu_CloseAllPages;
	TMenuItem *N6;
	TMenuItem *PopupMenu_New;
	TMenuItem *PopupMenu_Open;
	TMenuItem *N2;
	TMenuItem *PopupMenu_Save;
	TMenuItem *PopupMenu_SaveAs;
	TMenuItem *PopupMenu_SaveAll;
	TMenuItem *N1;
	TMenuItem *PopupMenu_Find;
	TMenuItem *PopupMenu_Replace;
	TSaveDialog *FileSaveDlg;
	TOpenDialog *FileOpenDlg;
	TPrintDialog *PrinterDlg;
	TPrinterSetupDialog *PrinterSetupDlg;
	TPageControl *EditorPageControl;
	
	
	void __fastcall SplitPanelMouseDown(TObject *Sender, TMouseButton Button,TShiftState Shift, int X, int Y);
	void __fastcall SplitPanelMouseMove(TObject *Sender, TShiftState Shift, int X, int Y);
	void __fastcall SplitPanelMouseUp(TObject *Sender, TMouseButton Button,	TShiftState Shift, int X, int Y);

	
	
	
	
	

    // autocreated richedit events
    void __fastcall RichEditChange(TObject* Sender);
	void __fastcall RichEditDragDrop(TObject *Sender, TObject *Source, int X, int Y);
	void __fastcall RichEditDragOver(TObject *Sender, TObject *Source, int X, int Y, TDragState State, bool &Accept);
	void __fastcall RichEditSelectionChange(TObject *Sender);
    
	
	void __fastcall PopupMenu_ClosePageClick(TObject *Sender);
	void __fastcall PopupMenu_CloseAllPagesClick(TObject *Sender);
	void __fastcall PopupMenu_NewClick(TObject *Sender);
	void __fastcall PopupMenu_OpenClick(TObject *Sender);
	void __fastcall PopupMenu_SaveClick(TObject *Sender);
	void __fastcall PopupMenu_SaveAsClick(TObject *Sender);
	void __fastcall PopupMenu_SaveAllClick(TObject *Sender);
	void __fastcall PopupMenu_FindClick(TObject *Sender);
	void __fastcall PopupMenu_ReplaceClick(TObject *Sender);
	void __fastcall PopupMenuPopup(TObject *Sender);
	
	
	
	
	
	
	void __fastcall FormDestroy(TObject *Sender);
	
	
	
        
	
	
	
	void __fastcall FormCreate(TObject *Sender);
	void __fastcall FormShow(TObject *Sender);
	void __fastcall FormResize(TObject *Sender);
	void __fastcall FormCloseQuery(TObject *Sender, bool &CanClose);
	void __fastcall RichEditMouseDown(TObject *Sender, TMouseButton Button,
	TShiftState Shift, int X, int Y);
	void __fastcall EditorPageControlChange(TObject *Sender);
	void __fastcall RichEditKeyDown(TObject *Sender, WORD &Key, TShiftState Shift);
	void __fastcall RichEditKeyPress(TObject *Sender, char &Key);
public:	// User declarations
    HWND FClipboardOwner;
    TRichEdit* NewRichEdit;
    TTabSheet* NewTabSheet;
    String Units;

    TStringList* FOpCodes;
    TStringList* FRegisters;
    TStringList* FDirectives;
    TStringList* FSpecial;


    int SplitPanelDragging;
    TPoint MaxPosition;
    TPoint MinTrack;
    TPoint MaxTrack;


    void __fastcall OnGetMinMaxInfo(TWMGetMinMaxInfo& Message);
    void __fastcall OnChangeCBChain(TWMChangeCBChain& Message);
    void __fastcall OnDrawClipboard(TWMDrawClipboard& Message);

   /////////////////////////////////////////////////////////////////
   //FILEHANDLING FUNCTIONS										////
   /////////////////////////////////////////////////////////////////

    void __fastcall SetFileName();
    void __fastcall SetFileName(String FileName);
    void __fastcall SetFileName(TRichEdit* Editor);

	String __fastcall GetFileName();
	String __fastcall GetFileName(TRichEdit* Editor);
	String __fastcall GetFileNameOnly();

	void __fastcall FindNextUnitName();

    void __fastcall SetActiveEditor(TRichEdit* Editor);

    void __fastcall LoadFile(AnsiString FileName);
    void __fastcall SaveFile();
    void __fastcall SaveFile(AnsiString FileName);
    void __fastcall SaveFileAs();
    void __fastcall SaveFileAs(AnsiString FileName);

	void __fastcall CheckFileSave();
	void __fastcall CheckFileSave(TRichEdit* Editor);
	void __fastcall FileClose();
    void __fastcall FileCloseAll();
    void __fastcall FileSaveAll();


    void __fastcall FileOpen();		// this one was openclick(sender);



   /////////////////////////////////////////////////////////////////
   //MENUITEM UTILITIES FUNCTIONS								////
   /////////////////////////////////////////////////////////////////
   void __fastcall UpdateCursorPosition();
   void __fastcall SetModified(bool Value);
   void __fastcall UpdateInsOvw();

   void __fastcall CheckEditUndo();
   void __fastcall CheckCutCopyDelete();
   void __fastcall ClipboardChanged();

   void __fastcall OnFirstModify();
   void __fastcall OnUnModify();
   bool __fastcall CheckFileSaveAll();

   void __fastcall DisableEditorMenuItems();
   void __fastcall EnableEditorMenuItems();

    /////////////////////////////////////////////////////////////////
   //RICHEDIT UTILITIES FUNCTIONS								////
   /////////////////////////////////////////////////////////////////

   TRichEdit* __fastcall CurrentRichEdit(void);
   TRichEdit* __fastcall GetRichEdit(unsigned int i);

   void __fastcall NewRichEditSetup(TRichEdit* NewRE);
   void __fastcall SetEditRect();
   void __fastcall NewTab();


   void __fastcall Undo();
//   void __fastcall Redo();

   void __fastcall Cut();
   void __fastcall Copy();
   void __fastcall Paste();

   void __fastcall Delete();
   void __fastcall SelectAll();

   /////////////////////////////////////////////////////////////////
   //	E	N	D												////
   /////////////////////////////////////////////////////////////////




 // old existing methods

	void __fastcall Find();
   	void __fastcall Replace();
    void __fastcall SearchAgain();

    void __fastcall PrinterSetup();
    void __fastcall FilePrint();

    void __fastcall InsertFile(AnsiString FileName);
    void __fastcall PutEditorWindow(int top);
    void __fastcall TForm2::UpdatePanels(); // for splitpanel

	long __fastcall GetLineNum();
	long __fastcall GetLineStartSelIndex(long LineNum);
	void __fastcall SetDefaultAttributes();
	void __fastcall SetKeyWordAttributes();

  //////////// Functions included for backward compatibility
  //////////// These functions call the appropriate functions

 	void __fastcall FileSaveAs();	// this one should call SaveFile()
    void __fastcall FileSave();		// this one should call	FileSave()






	__fastcall TForm2(TComponent* Owner);

BEGIN_MESSAGE_MAP
  MESSAGE_HANDLER(WM_GETMINMAXINFO, TWMGetMinMaxInfo, OnGetMinMaxInfo)
  MESSAGE_HANDLER(WM_CHANGECBCHAIN, TWMChangeCBChain, OnChangeCBChain)
  MESSAGE_HANDLER(WM_DRAWCLIPBOARD, TWMDrawClipboard, OnDrawClipboard)
END_MESSAGE_MAP(TForm)

};
//---------------------------------------------------------------------------
extern TForm2 *Form2;
//---------------------------------------------------------------------------
#endif
